#!/bin/bash
# the directory of the script
DIR=`cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd`
echo "Working directory $DIR"

# the temp directory used, within $DIR
WORK_DIR=`mktemp -d -p "$DIR"`
echo "Creating temp working directory $WORK_DIR"

# deletes the temp directory
function cleanup {
  rm -rf "$WORK_DIR"
  echo "Deleted temp working directory $WORK_DIR"
}

# register the cleanup function to be called on the EXIT signal
#trap cleanup EXIT

# Download Files specified in files.diz
while IFS=! read type app version outputfile url md5 realver
do
  echo "Downloading $app Version: $version"
  #use -O for output file. define $outputfile yourself
  wget -c --no-check-certificate --tries=1 -O $DIR/../$outputfile --timeout=5 "$url"
  # use $(..) instead of backticks.
  calculated_md5=$(md5sum "$DIR/../$outputfile" | cut -f 1 -d " ")
  # compare md5
  case "$calculated_md5" in
    "$md5" )
      echo "$DIR/../$outputfile md5 ok"
    ;;
    *)
      echo "$DIR/../$outputfile md5 NOT ok"
      exit 1
    ;;
  esac
done < "$DIR/files.diz"

# Extract to specified dir and set some variables
while IFS=! read type app version outputfile url md5 realver
do
  mkdir -p $WORK_DIR/${type}/${realver}
  pushd $WORK_DIR/${type}/${realver}
  unzip $DIR/../$outputfile
  tar -zxf $DIR/../$outputfile
  rpm2cpio $DIR/../$outputfile | cpio -idmv
  rpm2cpio manager/*.x86_64.rpm | cpio -idmv
  rpm2cpio manager/*.i386.rpm | cpio -idmv
  popd
  mkdir -p $WORK_DIR/${app}-${version}/${type}/${realver}
  pushd $WORK_DIR/${app}-${version}/${type}/${realver}
  case "${type}" in
    "amd64" )
      mv $WORK_DIR/${type}/${realver}/linux_x64/cmdline/arcconf .
      mv $WORK_DIR/${type}/${realver}/linux_x64/arcconf .
      mv $WORK_DIR/${type}/${realver}/usr/lib64/lib* .
      mv $WORK_DIR/${type}/${realver}/usr/StorMan/arcconf .
      mv $WORK_DIR/${type}/${realver}/usr/StorMan/libstdc* .
      chmod +x arcconf
      dos2unix $WORK_DIR/${type}/${realver}/linux_x64/cmdline/*.{txt,TXT}
      mv $WORK_DIR/${type}/${realver}/linux_x64/cmdline/*.{txt,TXT} .
      dos2unix $WORK_DIR/${type}/${realver}/usr/StorMan/*.{txt,TXT}
      mv $WORK_DIR/${type}/${realver}/usr/StorMan/*.{txt,TXT} .
    ;;
    "i386" )
      mv $WORK_DIR/${type}/${realver}/linux/cmdline/arcconf .
      mv $WORK_DIR/${type}/${realver}/usr/lib/lib* .
      mv $WORK_DIR/${type}/${realver}/usr/StorMan/arcconf .
      mv $WORK_DIR/${type}/${realver}/usr/StorMan/libstdc* .
      chmod +x arcconf
      dos2unix $WORK_DIR/${type}/${realver}/linux/cmdline/*.{txt,TXT}
      mv $WORK_DIR/${type}/${realver}/linux/cmdline/*.{txt,TXT} .
      dos2unix $WORK_DIR/${type}/${realver}/usr/StorMan/*.{txt,TXT}
      mv $WORK_DIR/${type}/${realver}/usr/StorMan/*.{txt,TXT} .
    ;;
    *)
      echo "Wrong arch"
      exit 1
    ;;
  esac
  echo "${app}_${version}.orig.tar.gz" > $WORK_DIR/filename.txt
  echo "${app}-${version}" > $WORK_DIR/dirname.txt
  echo "${version}" > $WORK_DIR/version.txt
  popd
done < "$DIR/files.diz"

FILENAME=`cat $WORK_DIR/filename.txt`
DIRNAME=`cat $WORK_DIR/dirname.txt`
echo "Creating $DIR/../$FILENAME "

pushd $WORK_DIR
tar -czf $DIR/../$FILENAME $DIRNAME
popd

VER=`cat $WORK_DIR/version.txt`
echo "Importing $DIR/../$FILENAME as $VER into git"
exit 1

cleanup
gbp import-orig --pristine-tar -u $VER $DIR/../$FILENAME

exit 0
