#pragma once

#include <common/storage/FileEvent.h>
#include <common/storage/EntryInfo.h>
#include <string>

struct EventContext
{
   static constexpr uint32_t EVENTFLAG_NONE = 0;
   static constexpr uint32_t EVENTFLAG_MIRRORED = (1 << 0); // Event is for a mirrored entry
   static constexpr uint32_t EVENTFLAG_SECONDARY = (1 << 1); // Event generated by secondary node

   std::string entryId;
   std::string parentId;
   unsigned msgUserId;
   std::string targetParentId;
   unsigned linkCount;
   int64_t timestamp;
   uint32_t eventFlags;  // bitwise OR of EVENTFLAG_ values above.
};

EventContext makeEventContext(EntryInfo* entryInfo, std::string parentId, unsigned msgUserId,
      std::string targetParentId, unsigned linkCount, bool isSecondary);


struct FileEventLoggerIds
{
   uint32_t nodeId;
   uint16_t buddyGroupId;
};

struct FileEventLoggerParams
{
   std::string address;
   FileEventLoggerIds ids;
};

struct FileEventLogger;

FileEventLogger *createFileEventLogger(FileEventLoggerParams const& params);
void destroyFileEventLogger(FileEventLogger *logger);
void logEvent(FileEventLogger *logger, FileEvent const& event, EventContext const& eventCtx);
