/*
This library allows you to run nxclient 3.5.0-7 on versions of Glibc> = 2.28
https://sourceware.org/bugzilla/show_bug.cgi?id=1190
Use the following:
gcc -shared -ldl -fPIC ./libfix1190.c -o /usr/NX/lib/libfix1190.so
LD_PRELOAD = /usr/NX/lib/libfix1190.so /usr/NX/bin/nxclient
*/

#define _GNU_SOURCE 
#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <dlfcn.h>
#include <string.h>

static ssize_t (*real_recvmsg)(int socket, struct msghdr *msg, int flags);
static FILE * (*real_fopen)(const char *filename, const char *opentype);

FILE *ssh_fp = NULL;

FILE * fopen (const char *filename, const char *opentype){

      real_fopen = dlsym(RTLD_NEXT, "fopen");
      FILE *fp = real_fopen(filename,opentype);

      if ((memcmp(opentype,"r",1)) && (strstr(filename,"sshlog")!=NULL)){
            ssh_fp = fp;
      }
      return fp;
}

ssize_t recvmsg(int socket, struct msghdr *message, int flags){

      real_recvmsg = dlsym(RTLD_NEXT, "recvmsg");
      int ret = real_recvmsg(socket, message, flags);

      if ((ssh_fp)&&(ssh_fp->_flags & _IO_EOF_SEEN)) {
           clearerr(ssh_fp); 
      }

      return ret;
}
