/* Generated by xcc-0.5.3 */

/*
 * XCC - XML Compiler-Compiler
 * 
 * Copyright (c) 2000-2005 Evgeny Stambulchik
 * 
 * 
 *                           All Rights Reserved
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 * 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 * 
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* As a special exception, when this file is SOLELY used to provide the
   functionality as needed by an XCC-generated output at run-time (either
   copied by XCC into the output file or otherwise linked to), you may use
   this file without further restrictions, provided that its contents are
   preserved verbatim. */

/* Public stuff */

#ifndef __XCC_H_
#define __XCC_H_

#include <stdio.h>
#include <string.h>
#include <expat.h>

#define XCC_VERSION_MAJOR   0
#define XCC_VERSION_MINOR   5
#define XCC_VERSION_NANO    3

#define XCC_RETURN_SUCCESS   0
#define XCC_RETURN_FAILURE   1

#define XCC_NS_SEPARATOR    '|'

#define XCC_STACK_CHUNK_SIZE  16

#define XCC_BUFFSIZE        8192

#define XCC_DEFAULT_PREFIX    "xcc"


/* error codes */
#define XCC_ECNTX   1
#define XCC_EATTR   2
#define XCC_EELEM   3
#define XCC_EEMIN   4
#define XCC_EEMAX   5
#define XCC_EAREQ   6
#define XCC_EINTR   7

/* ------------------- */

#define xcc_realloc realloc

typedef void (*XCC_stack_data_free)(void *data); 

typedef int (*XCCExceptionHandler)(int ierrno,
    const char *entity, const char *context, void *udata);

typedef struct _XCCStack {
    unsigned int size;
    unsigned int depth;
    void **entries;
    XCC_stack_data_free data_free;
} XCCStack;

typedef struct _XCCElementEntry {
    int key;
    char *name;
} XCCElementEntry;

typedef struct _XCCParserData {
    int error;
    
    char *cbuffer;
    int cbufsize;
    int cbuflen;
    
    XCCStack *nodes;
    void *root;
    
    void *udata;
    
    XCCExceptionHandler exception_handler;

    XML_Parser parser;

} XCCParserData;

typedef struct {
    int          allowed;
    unsigned int minOccurs;
    unsigned int maxOccurs;
    unsigned int occurred;
} XCCOccurrence;

typedef struct _XCCNode {
    char *name;
    int  id;
    void *data;
    XCCOccurrence *occurrence;
} XCCNode;

void xcc_get_version_numbers(int *major, int *minor, int *nano);

void *xcc_malloc(size_t size);
void xcc_free(void *p);

void xcc_error(const char *fmt, ...);

int xcc_stack_increment(XCCStack *xs, const void *data);
int xcc_stack_decrement(XCCStack *xs);
int xcc_stack_get_last(const XCCStack *xs, void **data);
int xcc_stack_depth(const XCCStack *xs);

XCCNode *xcc_node_new(void);

char *xcc_get_local(const char *name, const char *ns_uri, int *skip);

char **xcc_augment_attributes(const char **attr,
    unsigned int n2, char **attr2);

void *xcc_get_root(const XCCParserData *pdata);
int xcc_get_linenum(const XCCParserData *pdata);

int xcc_run(FILE *fp, void **root, void *udata,
              XML_StartElementHandler start_element_handler,
              XML_EndElementHandler end_element_handler,
              XCCExceptionHandler exception_handler);

#endif /* __XCC_H_ */
/*
 * XCC - XML Compiler-Compiler
 * 
 * Copyright (c) 2000-2005 Evgeny Stambulchik
 * 
 * 
 *                           All Rights Reserved
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 * 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 * 
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* As a special exception, when this file is SOLELY used to provide the
   functionality as needed by an XCC-generated output at run-time (either
   copied by XCC into the output file or otherwise linked to), you may use
   this file without further restrictions, provided that its contents are
   preserved verbatim. */

#include <string.h>
#include <stdarg.h>


void xcc_get_version_numbers(int *major, int *minor, int *nano)
{
    *major = XCC_VERSION_MAJOR;
    *minor = XCC_VERSION_MINOR;
    *nano  = XCC_VERSION_NANO;
}

void xcc_error(const char *fmt, ...)
{
    va_list ap;

    va_start(ap, fmt);
    fputs("xcc: ", stderr);
    vfprintf(stderr, fmt, ap);
    fputc('\n', stderr);
    va_end(ap);
}

void xcc_free(void *p)
{
    if (p) {
        free(p);
    }
}

void *xcc_malloc(size_t size)
{
    if (size == 0) {
        return NULL;
    } else {
        void *p = malloc(size);
        if (p) {
            return p;
        } else {
            xcc_error("memory exhausted");
            abort();
        }
    }
}

char *xcc_strdup(const char *s)
{
    char *ret;
    if (s) {
        ret = xcc_malloc(strlen(s) + 1);
        if (ret) {
            strcpy(ret, s);
        }
    } else {
        ret = NULL;
    }
    return ret;
}

XCCStack *xcc_stack_new(XCC_stack_data_free data_free)
{
    XCCStack *xs = xcc_malloc(sizeof(XCCStack));
    
    if (xs) {
        xs->size      = 0;
        xs->depth     = 0;
        xs->entries   = NULL;
        xs->data_free = data_free;
    }
    
    return xs;
}

void xcc_stack_free(XCCStack *xs)
{
    if (xs) {
        while (xs->depth) {
            void *e;
            xs->depth--;
            e = xs->entries[xs->depth];
            if (e && xs->data_free) {
                xs->data_free(e);
            }
        }
        xcc_free(xs->entries);
        
        xcc_free(xs);
    }
}

int xcc_stack_increment(XCCStack *xs, const void *data)
{
    if (xs->size <= xs->depth) {
        unsigned int new_size = xs->size + XCC_STACK_CHUNK_SIZE;
        void **p = xcc_realloc(xs->entries, new_size*sizeof(void *));
        if (!p) {
            return XCC_RETURN_FAILURE;
        } else {
            xs->entries = p;
            xs->size = new_size;
        }
    }
    xs->entries[xs->depth] = (void *) data;
    xs->depth++;
    
    return XCC_RETURN_SUCCESS;
}

int xcc_stack_decrement(XCCStack *xs)
{
    if (xs->depth < 1) {
        return XCC_RETURN_FAILURE;
    } else {
        void *e;
        xs->depth--;
        e = xs->entries[xs->depth];
        if (e && xs->data_free) {
            xs->data_free(e);
        }
        
        return XCC_RETURN_SUCCESS;
    }
}

int xcc_stack_get_first(const XCCStack *xs, void **data)
{
    if (xs && xs->depth > 0) {
        *data = xs->entries[0];
        return XCC_RETURN_SUCCESS;
    } else {
        return XCC_RETURN_FAILURE;
    }
}

int xcc_stack_get_last(const XCCStack *xs, void **data)
{
    if (xs && xs->depth > 0) {
        *data = xs->entries[xs->depth - 1];
        return XCC_RETURN_SUCCESS;
    } else {
        return XCC_RETURN_FAILURE;
    }
}

int xcc_stack_get_data(const XCCStack *xs, unsigned int ind, void **data)
{
    if (xs && xs->depth > ind) {
        *data = xs->entries[ind];
        return XCC_RETURN_SUCCESS;
    } else {
        return XCC_RETURN_FAILURE;
    }
}

int xcc_stack_depth(const XCCStack *xs)
{
    return xs->depth;
}


XCCNode *xcc_node_new(void)
{
    XCCNode *n;
    n = xcc_malloc(sizeof(XCCNode));
    if (n) {
        memset(n, 0, sizeof(XCCNode));
    }
    return n;
}

void xcc_node_free(XCCNode *n)
{
    if (n) {
        xcc_free(n->name);
        xcc_free(n->occurrence);
        xcc_free(n);
    }
}

char *xcc_get_local(const char *name, const char *ns_uri, int *skip)
{
    char *sep, *local_name;
    if (ns_uri && (sep = strchr(name, XCC_NS_SEPARATOR))) {
        char *buf = strstr(name, ns_uri);
        if (buf != name) {
            *skip = 1;
        }
        local_name = xcc_strdup(sep + 1);
    } else {
        local_name = xcc_strdup(name);
    }
    
    return local_name;
}

/* NB: attr1 is NULL-terminated, attr2 is NOT */
char **xcc_augment_attributes(const char **attr,
    unsigned int n2, char **attr2)
{
    unsigned int nattr, i2;
    int nextra = 2*n2;
    
    if (!n2) {
        return (char **) attr;
    }

    for (nattr = 0; attr[nattr]; nattr += 2) {
        const char *aname = attr[nattr];
        for (i2 = 0; i2 < 2*n2; i2 += 2) {
            char *aname2 = attr2[i2];
            if (aname2 && !strcmp(aname, aname2)) {
                attr2[i2] = NULL;
                nextra -= 2;
            }
        } 
    }
    
    if (nextra <= 0) {
        /* actually, it CAN'T be negative... */
        return (char **) attr;
    } else {
        unsigned nnew = nattr + nextra;
        char **attr_new = xcc_malloc((nnew + 1)*sizeof(char *));
        if (attr_new) {
            unsigned int inew = nattr;
            memcpy(attr_new, attr, nattr*sizeof(char *));
            for (i2 = 0; i2 < 2*n2; i2 += 2) {
                if (attr2[i2]) {
                    attr_new[inew] = attr2[i2];
                    attr_new[inew + 1] = attr2[i2 + 1];
                    inew += 2;
                }
            }
            attr_new[nnew] = NULL;
        }
        
        return attr_new;
    }
}

void *xcc_get_root(const XCCParserData *pdata)
{
    void *p;
    if (xcc_stack_get_data(pdata->nodes, 0, &p) != XCC_RETURN_SUCCESS) {
        return NULL;
    } else {
        XCCNode *node = p;
        return node->data;
    }
}

int xcc_get_linenum(const XCCParserData *pdata)
{
    if (pdata && pdata->parser) {
        return XML_GetCurrentLineNumber(pdata->parser);
    } else {
        return -1;
    }
}

static void xcc_char_data_handler(void *data, const char *s, int len)
{
    XCCParserData *pdata = (XCCParserData *) data;
    int new_len;

    if (pdata->error) {
        return;
    }
    
    new_len = pdata->cbuflen + len;
    
    if (new_len >= pdata->cbufsize) {
        pdata->cbuffer = xcc_realloc(pdata->cbuffer, (new_len + 1));
        pdata->cbufsize = new_len + 1;
    }
    
    memcpy(pdata->cbuffer + pdata->cbuflen, s, len);
    pdata->cbuffer[new_len] = '\0';
    pdata->cbuflen = new_len;
}


static int xcc_exception_handler(int ierrno,
    const char *entity, const char *context, void *udata)
{
    int handled = 0;
    
    switch (ierrno) {
    case XCC_ECNTX:
        xcc_error("unexpected \"%s\" in the context of \"%s\"", entity, context ? context:"xml");
        break;
    case XCC_EATTR:
        xcc_error("unknown attribute \"%s\" of element \"%s\"", entity, context);
        break;
    case XCC_EELEM:
        xcc_error("unknown element \"%s\" appeared in context of \"%s\"", entity, context);
        break;
    case XCC_EEMIN:
        xcc_error("underrun of occurrences of \"%s\" in the context of \"%s\"", entity, context);
        break;
    case XCC_EEMAX:
        xcc_error("overrun of occurrences of \"%s\" in the context of \"%s\"", entity, context);
        break;
    case XCC_EAREQ:
        xcc_error("required attribute \"%s\" of element \"%s\" is missing", entity, context);
        break;
    case XCC_EINTR:
        xcc_error("internal error");
        break;
    }
    
    return handled;
}

int xcc_run(FILE *fp, void **root, void *udata,
              XML_StartElementHandler start_element_handler,
              XML_EndElementHandler end_element_handler,
              XCCExceptionHandler exception_handler)
{
    XML_Parser xp;
    XCCParserData pdata;
    char Buff[XCC_BUFFSIZE];
    
    xp = XML_ParserCreateNS(NULL, XCC_NS_SEPARATOR);
    if (!xp) {
        *root = NULL;
        xcc_error("Couldn't allocate memory for parser");
        return XCC_RETURN_FAILURE;
    }

    /* Set XML_Parser's user data */
    pdata.error    = 0;
    
    pdata.cbuffer  = NULL;
    pdata.cbufsize = 0;
    pdata.cbuflen  = 0;
 
    pdata.nodes    = xcc_stack_new((XCC_stack_data_free) xcc_node_free);
    pdata.root     = NULL;
    
    pdata.udata    = udata;
    pdata.parser   = xp;

    if (exception_handler) {
        pdata.exception_handler = exception_handler;
    } else {
        pdata.exception_handler = xcc_exception_handler;
    }
    
    XML_SetUserData(xp, (void *) &pdata);

    XML_SetElementHandler(xp, start_element_handler, end_element_handler);

    /* Set the char data handler */
    XML_SetCharacterDataHandler(xp, xcc_char_data_handler);

    while (!pdata.error) {
        int done;
        int len;

        len = fread(Buff, 1, XCC_BUFFSIZE, fp);
        if (ferror(fp)) {
            xcc_error("Read error");
            pdata.error = 1;
            break;
        }
        done = feof(fp);

        if (!XML_Parse(xp, Buff, len, done)) {
            xcc_error("parse error at line %d:\n\t%s",
                XML_GetCurrentLineNumber(xp),
                XML_ErrorString(XML_GetErrorCode(xp)));
            pdata.error = 1;
            break;
        }

        if (done) {
            break;
        }
    }
    
    /* Free allocated storage */
    XML_ParserFree(xp);
    xcc_stack_free(pdata.nodes);
    xcc_free(pdata.cbuffer);
    
    *root = pdata.root;
    if (!pdata.error) {
        return XCC_RETURN_SUCCESS;
    } else {
        return XCC_RETURN_FAILURE;
    }
}
#line 3 "patterndb_parser.xcc"

/*
 * This file is part of the nxlog log collector tool.
 * See the file LICENSE in the source root for licensing terms.
 * Website: http://nxlog.org
 * Author: Botond Botyanszki <botond.botyanszki@nxlog.org>
 */

#include "patterndb.h"
#include "../../../common/exception.h"

#define NX_LOGMODULE NX_LOGMODULE_MODULE

typedef struct nx_patterndb_parser_data_t
{
    apr_pool_t *pool; ///< parent pool
    nx_patterndb_t *patterndb;
    const char *filename;
} nx_patterndb_parser_data_t;

#define XCC_GET_PATTERNDB(X) (((nx_patterndb_parser_data_t *) ((XCCParserData *)(X))->udata)->patterndb)
#define XCC_GET_PATTERNDB_POOL(X) ((((nx_patterndb_parser_data_t *) ((XCCParserData *)(X))->udata)->patterndb)->pool)
#define XCC_GET_FILENAME(X) (((nx_patterndb_parser_data_t *) ((XCCParserData *)(X))->udata)->filename)

    
#line 595 "patterndb_parser.c"
typedef void *XCCAType;
typedef union {
    void * ignored;
    const char * string;
    nx_patterndb_t * patterndb;
    nx_patterngroup_t * patterngroup;
    nx_pattern_t * pattern;
    nx_pattern_matchfield_t * matchfield;
    nx_pattern_capturedfield_t * capturedfield;
    nx_logdata_field_list_t * field_list;
    nx_pattern_field_t * field;
    nx_expr_statement_list_t * statements;
    int id;
    void * unicast;
} XCCEType;

static XCCElementEntry XCCElementTab[] = {
    {1, "patterndb"},
    {2, "group"},
    {3, "pattern"},
    {4, "matchfield"},
    {5, "capturedfield"},
    {6, "field"},
    {7, "type"},
    {8, "fieldname"},
    {9, "name"},
    {10, "description"},
    {11, "value"},
    {12, "id"},
    {13, "exec"},
    {14, "created"},
    {15, "version"},
    {16, "set"},
    {17, "testcase"},
    {18, "capturedvalue"}
};

static int get_element_id_by_name(const char *name)
{
    int i;
    for (i = 0; i < 18; i++) {
        if (!strcmp(XCCElementTab[i].name, name)) {
            return XCCElementTab[i].key;
        }
    }
    return -1;
}

static char *get_element_name_by_id(int id)
{
    int i;
    for (i = 0; i < 18; i++) {
        if (XCCElementTab[i].key == id) {
            return XCCElementTab[i].name;
        }
    }
    return NULL;
}

static XCCOccurrence *init_occurrence(int element_id)
{
    XCCOccurrence *occurrence;
    switch (element_id) {
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
        return NULL;
        break;
    }

    occurrence = xcc_malloc(18*sizeof(XCCOccurrence));
    if (occurrence) {
        memset(occurrence, 0, 18*sizeof(XCCOccurrence));
        switch (element_id) {
        case 1:
            occurrence[13].allowed = 1;
            occurrence[13].maxOccurs = 1;
            occurrence[14].allowed = 1;
            occurrence[14].maxOccurs = 1;
            occurrence[1].allowed = 1;
            break;
        case 2:
            occurrence[11].allowed = 1;
            occurrence[11].minOccurs = 1;
            occurrence[11].maxOccurs = 1;
            occurrence[8].allowed = 1;
            occurrence[9].allowed = 1;
            occurrence[9].maxOccurs = 1;
            occurrence[2].allowed = 1;
            occurrence[3].allowed = 1;
            break;
        case 3:
            occurrence[11].allowed = 1;
            occurrence[11].minOccurs = 1;
            occurrence[11].maxOccurs = 1;
            occurrence[8].allowed = 1;
            occurrence[8].minOccurs = 1;
            occurrence[8].maxOccurs = 1;
            occurrence[9].allowed = 1;
            occurrence[9].maxOccurs = 1;
            occurrence[3].allowed = 1;
            occurrence[15].allowed = 1;
            occurrence[12].allowed = 1;
            occurrence[16].allowed = 1;
            break;
        case 4:
            occurrence[8].allowed = 1;
            occurrence[8].minOccurs = 1;
            occurrence[8].maxOccurs = 1;
            occurrence[6].allowed = 1;
            occurrence[6].minOccurs = 1;
            occurrence[6].maxOccurs = 1;
            occurrence[10].allowed = 1;
            occurrence[10].minOccurs = 1;
            occurrence[10].maxOccurs = 1;
            occurrence[4].allowed = 1;
            break;
        case 5:
            occurrence[8].allowed = 1;
            occurrence[8].minOccurs = 1;
            occurrence[8].maxOccurs = 1;
            occurrence[6].allowed = 1;
            occurrence[6].minOccurs = 1;
            occurrence[6].maxOccurs = 1;
            break;
        case 6:
            occurrence[8].allowed = 1;
            occurrence[8].minOccurs = 1;
            occurrence[8].maxOccurs = 1;
            occurrence[10].allowed = 1;
            occurrence[10].minOccurs = 1;
            occurrence[10].maxOccurs = 1;
            occurrence[6].allowed = 1;
            occurrence[6].minOccurs = 1;
            occurrence[6].maxOccurs = 1;
            break;
        case 16:
            occurrence[5].allowed = 1;
            break;
        case 17:
            occurrence[5].allowed = 1;
            occurrence[17].allowed = 1;
            break;
        case 18:
            occurrence[8].allowed = 1;
            occurrence[8].minOccurs = 1;
            occurrence[8].maxOccurs = 1;
            occurrence[10].allowed = 1;
            occurrence[10].minOccurs = 1;
            occurrence[10].maxOccurs = 1;
            occurrence[6].allowed = 1;
            occurrence[6].minOccurs = 1;
            occurrence[6].maxOccurs = 1;
            break;
        }
    }
    return occurrence;
}

static void xcc_start_handler(void *data, const char *el, const char **attr_in)
{
    char **attr;
    XCCParserData *pdata = (XCCParserData *) data;
    XCCNode *pnode = NULL, *node;
    XCCEType element;
    int i, element_id = -1, parent_id = -1, skip = 0, askip;
    const char *avalue;
    char *aname, *el_local;
    unsigned int nattr_extra  = 0;
    char *attr_extra[0];
    if (pdata->error) {
        return;
    }

    pdata->cbuflen = 0;
    if (pdata->cbufsize) {
        pdata->cbuffer[0] = '\0';
    }

    element.unicast = NULL;

    el_local  = xcc_get_local(el, NULL, &skip);
    if (skip) {
        goto e_switch;
    }

    if (xcc_stack_depth(pdata->nodes) == 0) {
        pnode = NULL;
        parent_id = 0;
    } else {
        void *p;
        xcc_stack_get_last(pdata->nodes, &p);
        pnode = p;
        parent_id = pnode->id;
    }
    if (parent_id < 0) {
        skip = 1;
        goto e_switch;
    }

    element_id = get_element_id_by_name(el_local);
    if (element_id < 0) {
        if (pdata->exception_handler(XCC_EELEM, el_local, pnode ? pnode->name:NULL, pdata->udata)) {
            skip = 1;
        } else {
            pdata->error = 1;
        }
        goto e_switch;
    }

    if (!pnode) {
        goto e_switch;
    }

    if (pnode->occurrence) {
        pnode->occurrence[element_id - 1].occurred++;
    }

    if (!pnode->occurrence || !pnode->occurrence[element_id - 1].allowed) {
        if (pdata->exception_handler(XCC_ECNTX, el_local, pnode ? pnode->name:NULL, pdata->udata)) {
            skip = 1;
        } else {
            pdata->error = 1;
        }
        goto e_switch;
    }

    if (pnode->occurrence[element_id - 1].maxOccurs &&
        pnode->occurrence[element_id - 1].occurred > pnode->occurrence[element_id - 1].maxOccurs) {
        if (pdata->exception_handler(XCC_EEMAX, el_local, pnode->name, pdata->udata)) {
            skip = 1;
        } else {
            pdata->error = 1;
        }
        goto e_switch;
    }

e_switch:

    switch (element_id) {
    case 1: /* patterndb */
#line 35 "patterndb_parser.xcc"

     
         element.patterndb = nx_patterndb_new(((const nx_patterndb_parser_data_t *) ((const XCCParserData *)(pdata))->udata)->pool);
         XCC_GET_PATTERNDB(pdata) = element.patterndb;
      
    
#line 850 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 2: /* group */
#line 42 "patterndb_parser.xcc"

     
        element.patterngroup = nx_patterngroup_new(XCC_GET_PATTERNDB(pdata));
     
    
#line 877 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 3: /* pattern */
#line 48 "patterndb_parser.xcc"

     
        element.pattern = nx_pattern_new(XCC_GET_PATTERNDB(pdata));
     
    
#line 904 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 4: /* matchfield */
#line 54 "patterndb_parser.xcc"

     
        element.matchfield = nx_pattern_matchfield_new(XCC_GET_PATTERNDB(pdata));
     
    
#line 931 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 5: /* capturedfield */
#line 60 "patterndb_parser.xcc"

     
        element.capturedfield = apr_pcalloc(XCC_GET_PATTERNDB_POOL(pdata), sizeof(nx_pattern_capturedfield_t));
     
    
#line 958 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 6: /* field */
#line 73 "patterndb_parser.xcc"

     
        element.field = malloc(sizeof(nx_pattern_field_t));
     
    
#line 985 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 7: /* type */
#line 32 "patterndb_parser.xcc"

    
#line 1009 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 8: /* fieldname */
#line 32 "patterndb_parser.xcc"

    
#line 1033 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 9: /* name */
#line 32 "patterndb_parser.xcc"

    
#line 1057 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 10: /* description */
#line 32 "patterndb_parser.xcc"

    
#line 1081 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 11: /* value */
#line 32 "patterndb_parser.xcc"

    
#line 1105 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 12: /* id */
#line 32 "patterndb_parser.xcc"

    
#line 1129 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 13: /* exec */
#line 32 "patterndb_parser.xcc"

    
#line 1153 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 14: /* created */
#line 29 "patterndb_parser.xcc"

    
#line 1177 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 15: /* version */
#line 29 "patterndb_parser.xcc"

    
#line 1201 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 16: /* set */
#line 66 "patterndb_parser.xcc"

     
        element.field_list = apr_pcalloc(XCC_GET_PATTERNDB_POOL(pdata), sizeof(nx_logdata_field_list_t));
        NX_DLIST_INIT(element.field_list, nx_logdata_field_list_t, link);
     
    
#line 1229 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 17: /* testcase */
#line 29 "patterndb_parser.xcc"

    
#line 1253 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    case 18: /* capturedvalue */
#line 73 "patterndb_parser.xcc"

     
        element.field = malloc(sizeof(nx_pattern_field_t));
     
    
#line 1280 "patterndb_parser.c"
        attr = xcc_augment_attributes(attr_in, nattr_extra, attr_extra);
        for (i = 0; attr[i]; i += 2) {
            askip = 0;
            aname  = xcc_get_local(attr[i], NULL, &askip);
            avalue = attr[i + 1];
            {
               if (!askip && pdata->exception_handler(XCC_EATTR, aname, el_local, pdata->udata)) {
                   askip = 1;
               }
               if (!askip) {
                   pdata->error = 1;
               }
            }
            xcc_free(aname);
        }
        if (attr != (char **) attr_in) {
            xcc_free(attr);
        }
        break;
    }

    if (skip) {
        element_id = -1;
    }
    node = xcc_node_new();
    node->name = el_local;
    node->id = element_id;
    node->data = element.unicast;
    node->occurrence = init_occurrence(element_id);
    xcc_stack_increment(pdata->nodes, node);
}

static void xcc_end_handler(void *data, const char *el)
{
    XCCParserData *pdata = (XCCParserData *) data;
    XCCNode *node, *pnode;
    void *p;
    int element_id, parent_id, parent_child, skip = 0;
    XCCEType element, pelement;
    char *cdata = pdata->cbuffer;

    if (pdata->error) {
        return;
    }

    xcc_stack_get_last(pdata->nodes, &p);
    node = p;
    element_id = node->id;
    element.unicast = node->data;
    switch (element_id) {
    case 7: /* type */
        {
#line 215 "patterndb_parser.xcc"

            element.string = cdata;
        
#line 1337 "patterndb_parser.c"
        }
        break;
    case 8: /* fieldname */
        {
#line 221 "patterndb_parser.xcc"

            element.string = cdata;
        
#line 1346 "patterndb_parser.c"
        }
        break;
    case 9: /* name */
        {
#line 227 "patterndb_parser.xcc"

            element.string = cdata;
        
#line 1355 "patterndb_parser.c"
        }
        break;
    case 10: /* description */
        {
#line 233 "patterndb_parser.xcc"

            element.string = cdata;
        
#line 1364 "patterndb_parser.c"
        }
        break;
    case 11: /* value */
        {
#line 239 "patterndb_parser.xcc"

            element.string = cdata;
        
#line 1373 "patterndb_parser.c"
        }
        break;
    case 12: /* id */
        {
#line 245 "patterndb_parser.xcc"

            element.string = cdata;
        
#line 1382 "patterndb_parser.c"
        }
        break;
    case 13: /* exec */
        {
#line 251 "patterndb_parser.xcc"

            element.string = cdata;
        
#line 1391 "patterndb_parser.c"
        }
        break;
    }

    if (node->occurrence) {
        unsigned int i;
        for (i = 0; i < 18; i++) {
            if (node->occurrence[i].occurred < node->occurrence[i].minOccurs) {
                char *cname = get_element_name_by_id(i + 1);
                if (!pdata->exception_handler(XCC_EEMIN, cname, node->name, pdata->udata)) {
                    pdata->error = 1;
                }
            }
        }
    }

    xcc_stack_decrement(pdata->nodes);
    if (xcc_stack_depth(pdata->nodes) == 0) {
        pdata->root = element.unicast;
        parent_id  = 0;
        pelement.unicast = NULL;
    } else {
        xcc_stack_get_last(pdata->nodes, &p);
        pnode = p;
        parent_id  = pnode->id;
        pelement.unicast = pnode->data;
    }
    if (parent_id >= 0 && element_id >= 0) {
        parent_child = 18*parent_id + element_id;
    } else {
        parent_child = -1;
        skip = 1;
    }

    switch (parent_child) {
    case 1:
        break;
    case 32:
        {
#line 87 "patterndb_parser.xcc"

	
#line 1434 "patterndb_parser.c"
        }
        break;
    case 33:
        {
#line 89 "patterndb_parser.xcc"

	
#line 1442 "patterndb_parser.c"
        }
        break;
    case 20:
        {
#line 91 "patterndb_parser.xcc"

           
               nx_patterndb_add_group(pelement.patterndb, element.patterngroup);
           
	
#line 1453 "patterndb_parser.c"
        }
        break;
    case 48:
        {
#line 99 "patterndb_parser.xcc"

           
               pelement.patterngroup->id = atoi(element.string);
               log_debug("patterngroup id: %ld", pelement.patterngroup->id);
           
	
#line 1465 "patterndb_parser.c"
        }
        break;
    case 45:
        {
#line 105 "patterndb_parser.xcc"

           
               pelement.patterngroup->name = apr_pstrdup(XCC_GET_PATTERNDB_POOL(pdata), element.string);
               log_debug("patterngroup name: %s", pelement.patterngroup->name);
           
	
#line 1477 "patterndb_parser.c"
        }
        break;
    case 46:
        {
#line 111 "patterndb_parser.xcc"

#line 1484 "patterndb_parser.c"
        }
        break;
    case 39:
        {
#line 112 "patterndb_parser.xcc"

           
               nx_patterngroup_add_pattern(pelement.patterngroup, element.pattern);
           
	
#line 1495 "patterndb_parser.c"
        }
        break;
    case 40:
        {
#line 117 "patterndb_parser.xcc"

           
               nx_patterngroup_add_matchfield(XCC_GET_PATTERNDB_POOL(pdata), pelement.patterngroup, element.matchfield);
           
	
#line 1506 "patterndb_parser.c"
        }
        break;
    case 66:
        {
#line 125 "patterndb_parser.xcc"

           
               pelement.pattern->id = atoi(element.string);
               log_debug("pattern id: %ld", pelement.pattern->id);
           
	
#line 1518 "patterndb_parser.c"
        }
        break;
    case 63:
        {
#line 131 "patterndb_parser.xcc"

           
               pelement.pattern->name = apr_pstrdup(XCC_GET_PATTERNDB_POOL(pdata), element.string);
           
	
#line 1529 "patterndb_parser.c"
        }
        break;
    case 64:
        {
#line 136 "patterndb_parser.xcc"

#line 1536 "patterndb_parser.c"
        }
        break;
    case 58:
        {
#line 137 "patterndb_parser.xcc"

          
               nx_pattern_add_matchfield(XCC_GET_PATTERNDB_POOL(pdata), pelement.pattern, element.matchfield);
           
	
#line 1547 "patterndb_parser.c"
        }
        break;
    case 70:
        {
#line 142 "patterndb_parser.xcc"

          
               pelement.pattern->setfields = element.field_list;
           
	
#line 1558 "patterndb_parser.c"
        }
        break;
    case 67:
        {
#line 147 "patterndb_parser.xcc"

          
               nx_patterndb_parse_exec_block(NULL, XCC_GET_PATTERNDB(pdata), pelement.pattern, element.string, XCC_GET_FILENAME(pdata),
                                             xcc_get_linenum(pdata), 1); //TODO linepos
            
	
#line 1570 "patterndb_parser.c"
        }
        break;
    case 71:
        {
#line 153 "patterndb_parser.xcc"

          
             //FIXME
           
	
#line 1581 "patterndb_parser.c"
        }
        break;
    case 81:
        {
#line 161 "patterndb_parser.xcc"

           
               pelement.matchfield->name = apr_pstrdup(XCC_GET_PATTERNDB_POOL(pdata), element.string);
           
	
#line 1592 "patterndb_parser.c"
        }
        break;
    case 79:
        {
#line 166 "patterndb_parser.xcc"

          
               pelement.matchfield->type = nx_pattern_match_type_from_string(element.string);
           
	
#line 1603 "patterndb_parser.c"
        }
        break;
    case 83:
        {
#line 171 "patterndb_parser.xcc"

           
               pelement.matchfield->value = apr_pstrdup(XCC_GET_PATTERNDB_POOL(pdata), element.string);
           
	
#line 1614 "patterndb_parser.c"
        }
        break;
    case 77:
        {
#line 176 "patterndb_parser.xcc"

          
               nx_pattern_matchfield_add_capturedfield(pelement.matchfield, element.capturedfield);
           
	
#line 1625 "patterndb_parser.c"
        }
        break;
    case 99:
        {
#line 184 "patterndb_parser.xcc"

           
               pelement.capturedfield->name = apr_pstrdup(XCC_GET_PATTERNDB_POOL(pdata), element.string);
           
	
#line 1636 "patterndb_parser.c"
        }
        break;
    case 97:
        {
#line 189 "patterndb_parser.xcc"

          
               pelement.capturedfield->type = nx_value_type_from_string(element.string);
           
	
#line 1647 "patterndb_parser.c"
        }
        break;
    case 117:
        {
#line 197 "patterndb_parser.xcc"

          
               pelement.field->name = strdup(element.string);
           
	
#line 1658 "patterndb_parser.c"
        }
        break;
    case 119:
        {
#line 202 "patterndb_parser.xcc"

          
               pelement.field->value = strdup(element.string);
           
	
#line 1669 "patterndb_parser.c"
        }
        break;
    case 115:
        {
#line 207 "patterndb_parser.xcc"

          
               pelement.field->type = nx_value_type_from_string(element.string);
           
	
#line 1680 "patterndb_parser.c"
        }
        break;
    case 294:
        {
#line 263 "patterndb_parser.xcc"

          
               nx_pattern_field_list_insert_field(XCC_GET_PATTERNDB_POOL(pdata), pelement.field_list, element.field->name, element.field->value, element.field->type);
               nx_pattern_field_free(element.field);
           
	
#line 1692 "patterndb_parser.c"
        }
        break;
    case 312:
        {
#line 272 "patterndb_parser.xcc"

	
#line 1700 "patterndb_parser.c"
        }
        break;
    case 324:
        {
#line 274 "patterndb_parser.xcc"

          
               nx_pattern_field_free(element.field);
           
	
#line 1711 "patterndb_parser.c"
        }
        break;
    case 333:
        {
#line 282 "patterndb_parser.xcc"

          
               pelement.field->name = strdup(element.string);
           
	
#line 1722 "patterndb_parser.c"
        }
        break;
    case 335:
        {
#line 287 "patterndb_parser.xcc"

          
               pelement.field->value = strdup(element.string);
           
	
#line 1733 "patterndb_parser.c"
        }
        break;
    case 331:
        {
#line 292 "patterndb_parser.xcc"

          
               pelement.field->type = nx_value_type_from_string(element.string);
           
	
#line 1744 "patterndb_parser.c"
        }
        break;
    default:
        if (!skip) {
            pdata->exception_handler(XCC_EINTR, NULL, NULL, pdata->udata);
            pdata->error = 1;
        }
        break;
    }

    pdata->cbuflen = 0;
    if (pdata->cbufsize) {
        pdata->cbuffer[0] = '\0';
    }
}

int xcc_parse(FILE *fp, void **root, void *udata, XCCExceptionHandler exception_handler)
{
    return xcc_run(fp, root, udata, xcc_start_handler, xcc_end_handler, exception_handler);
}
#line 299 "patterndb_parser.xcc"


//FIXME implement own error handler to throw exception with line number
//      and pass it to xcc_parse below
//int exception_handler(int ierrno, const char *entity, const char *context, void *udata)


nx_patterndb_t *nx_patterndb_parse(apr_pool_t *pool, const char *filename)
{
    FILE *f;
    nx_exception_t e;
    nx_patterndb_parser_data_t parser_data;

    ASSERT(pool != NULL);
    ASSERT(filename != NULL);

    memset(&parser_data, 0, sizeof(nx_patterndb_parser_data_t));
    parser_data.pool = pool;
    parser_data.filename = apr_pstrdup(pool, filename);

    f = fopen(filename, "r");
    if ( f == NULL )
    {
	throw_errno("Couldn't open pattern file '%s'", filename);
    }

    try
    {
	if ( xcc_parse(f, (void **) &(parser_data.patterndb), (void *) &parser_data, NULL) != XCC_RETURN_SUCCESS )
	{
	    throw_msg("failed to parse pattern database '%s'", filename);
	}
    }
    catch(e)
    {
	fclose(f);
	rethrow(e);
    }
    fclose(f);

    log_debug("pattern databse '%s' parsed successfully", filename);
    return ( parser_data.patterndb );
}

    
#line 1811 "patterndb_parser.c"
