#!/bin/bash
# the directory of the script
DIR=`cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd`
echo "Working directory $DIR"

# the temp directory used, within $DIR
WORK_DIR=`mktemp -d -p "$DIR"`
echo "Creating temp working directory $WORK_DIR"

# deletes the temp directory
function cleanup {
  rm -rf "$WORK_DIR"
  echo "Deleted temp working directory $WORK_DIR"
}

# register the cleanup function to be called on the EXIT signal
trap cleanup EXIT

# Download Files specified in files.diz
while IFS=! read type app version outputfile url md5
do
  echo "Downloading $app Version: $version"
  #use -O for output file. define $outputfile yourself
  wget -c --no-check-certificate --tries=1 -O $DIR/../$outputfile --timeout=5 "$url"
  # use $(..) instead of backticks.
  calculated_md5=$(md5sum "$DIR/../$outputfile" | cut -f 1 -d " ")
  # compare md5
  case "$calculated_md5" in
    "$md5" )
      echo "$DIR/../$outputfile md5 ok"
    ;;
    *)
      echo "$DIR/../$outputfile md5 NOT ok"
      exit 1
    ;;
  esac
done < "$DIR/files.diz"

# Extract to specified dir and set some variables
while IFS=! read type app version outputfile url md5
do
  mkdir -p $WORK_DIR/${type}
  pushd $WORK_DIR/${type}
  unzip $DIR/../$outputfile
  unzip *.zip
  popd
  mkdir -p $WORK_DIR/${app}-${version}/${type}
  dos2unix $WORK_DIR/${type}/STORCLI_SAS3.5_P35/univ_viva_cli_rel/Unified_storcli_all_os/*.txt
  dos2unix $WORK_DIR/${type}/*.txt
  mv $WORK_DIR/${type}/STORCLI_SAS3.5_P35/univ_viva_cli_rel/Unified_storcli_all_os/*.txt $WORK_DIR/${app}-${version}
  mv $WORK_DIR/${type}/*.txt $WORK_DIR/${app}-${version}
  pushd $WORK_DIR/${app}-${version}/${type}
  rpm2cpio $WORK_DIR/${type}/STORCLI_SAS3.5_P35/univ_viva_cli_rel/Unified_storcli_all_os/Linux/*.rpm | cpio -idmv
  rpm2cpio $WORK_DIR/${type}/Linux/*.rpm | cpio -idmv
  case "${type}" in
    "amd64" )
      rm -f opt/MegaRAID/storcli/storcli
    ;;
    "i386" )
      rm -f opt/MegaRAID/storcli/storcli64
    ;;
    *)
      echo "Wrong arch"
      exit 1
    ;;
  esac
  echo "${app}_${version}.orig.tar.gz" > $WORK_DIR/filename.txt
  echo "${app}-${version}" > $WORK_DIR/dirname.txt
  echo "${version}" > $WORK_DIR/version.txt
  popd
done < "$DIR/files.diz"

FILENAME=`cat $WORK_DIR/filename.txt`
DIRNAME=`cat $WORK_DIR/dirname.txt`
echo "Creating $DIR/../$FILENAME "

pushd $WORK_DIR
tar -czf $DIR/../$FILENAME $DIRNAME
popd

VER=`cat $WORK_DIR/version.txt`
echo "Importing $DIR/../$FILENAME as $VER into git"
#exit 1

cleanup
gbp import-orig --pristine-tar -u $VER $DIR/../$FILENAME

exit 0
